
from gurobipy import *

# Create a new model
m = Model("Jason_Nutrition")

# Create variables
x1 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="sports_drink")
x2 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="coconut_water")

# Set the objective function
m.setObjective(5*x1 + 3*x2, GRB.MINIMIZE)

# Add constraints
m.addConstr(x1 + 4*x2 >= 10, "calcium")
m.addConstr(2*x1 + x2 >= 15, "potassium")
m.addConstr(3*x1 + 2*x2 >= 13, "magnesium")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Sports drink bottles: {x1.x}")
    print(f"Coconut water bottles: {x2.x}")
    print(f"Total cost: ${5*x1.x + 3*x2.x:.2f}")
else:
    print("No optimal solution found")
