
import gurobipy as gp

def solve_jason_nutrition_problem():
    # Create a new model
    model = gp.Model("JasonNutrition")

    # Define variables
    x1 = model.addVar(name="sports_drink", lb=0, vtype=gp.GRB.CONTINUOUS)
    x2 = model.addVar(name="coconut_water", lb=0, vtype=gp.GRB.CONTINUOUS)

    # Objective function: minimize cost
    model.setObjective(5*x1 + 3*x2, gp.GRB.MINIMIZE)

    # Constraints
    model.addConstr(x1 + 4*x2 >= 10, name="calcium")
    model.addConstr(2*x1 + x2 >= 15, name="potassium")
    model.addConstr(3*x1 + 2*x2 >= 13, name="magnesium")

    # Solve the model
    model.optimize()

    # Print the results
    if model.status == gp.GRB.OPTIMAL:
        print(f"Optimal cost: ${model.objVal:.2f}")
        print(f"Bottles of sports drink: {x1.varValue:.2f}")
        print(f"Bottles of coconut water: {x2.varValue:.2f}")
    else:
        print("No optimal solution found.")

solve_jason_nutrition_problem()
