
import gurobipy as gp

# Create a new model
m = gp.Model("kitchen_appliance_optimization")

# Create variables
fridges = m.addVar(vtype=gp.GRB.CONTINUOUS, name="fridges")
stoves = m.addVar(vtype=gp.GRB.CONTINUOUS, name="stoves")

# Set objective function
m.setObjective(400 * fridges + 500 * stoves, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(10 * fridges + 15 * stoves <= 1000, "floor_space")
m.addConstr(fridges >= 0.4 * (fridges + stoves), "fridge_proportion")
m.addConstr(1000 * fridges + 1200 * stoves <= 40000, "capital")
m.addConstr(fridges >= 0, "fridges_nonnegative")
m.addConstr(stoves >= 0, "stoves_nonnegative")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal profit: {m.objVal}")
    print(f"Number of fridges: {fridges.x}")
    print(f"Number of stoves: {stoves.x}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

