
from gurobipy import *

# Create a model
m = Model("Appliance_Optimization")

# Define variables
x1 = m.addVar(vtype=GRB.INTEGER, name="fridges")
x2 = m.addVar(vtype=GRB.INTEGER, name="stoves")

# Set the objective function
m.setObjective(400*x1 + 500*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(10*x1 + 15*x2 <= 1000, "floor_space")
m.addConstr(1.5*x1 >= x2, "fridge_percentage")
m.addConstr(1000*x1 + 1200*x2 <= 40000, "capital")

# Optimize the model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Number of fridges: {x1.x}")
    print(f"Number of stoves: {x2.x}")
    print(f"Maximum profit: {m.objVal}")
else:
    print("No optimal solution found.")
