
import gurobi

def solve_appliance_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(name="fridge", lb=0, vtype=gurobi.GRB.CONTINUOUS)
    x2 = model.addVar(name="stove", lb=0, vtype=gurobi.GRB.CONTINUOUS)

    # Objective function
    model.setObjective(400*x1 + 500*x2, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(10*x1 + 15*x2 <= 1000, name="floor_space")
    model.addConstr(3*x1 - 2*x2 >= 0, name="product_mix")
    model.addConstr(1000*x1 + 1200*x2 <= 40000, name="capital")

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal Solution:")
        print(f"Fridges: {x1.varValue}")
        print(f"Stoves: {x2.varValue}")
        print(f"Max Profit: {model.objVal}")
    else:
        print("The model is infeasible")

solve_appliance_problem()
