
import gurobipy as gp

# Create a new model
m = gp.Model("Investment_Problem")

# Create decision variables
airline = m.addVar(lb=0, name="airline")  # Investment in airline industry
railway = m.addVar(lb=0, name="railway")  # Investment in railway industry


# Set objective function: Maximize profit
m.setObjective(0.3 * airline + 0.1 * railway, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(airline + railway <= 50000, "Total_Investment")  # Total investment limit
m.addConstr(railway >= 10000, "Min_Railway")  # Minimum investment in railway
m.addConstr(airline >= 0.25 * (airline + railway), "Airline_Proportion")  # Airline investment proportion


# Optimize the model
m.optimize()

# Print the optimal solution
if m.status == gp.GRB.OPTIMAL:
    print("Optimal Solution:")
    print("Airline Investment:", airline.x)
    print("Railway Investment:", railway.x)
    print("Total Profit:", m.objVal)
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization terminated with status:", m.status)

