
import gurobi

def solve_investment_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="airline_investment", lb=0)
    x2 = model.addVar(name="railway_investment", lb=0)

    # Objective function: Maximize 0.30*x1 + 0.10*x2
    model.setObjective(0.30 * x1 + 0.10 * x2, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(x1 + x2 <= 50000, name="total_investment")
    model.addConstr(x2 >= 10000, name="railway_min_investment")
    model.addConstr(3 * x1 >= x2, name="airline_min_percentage")

    # Optimize the model
    model.optimize()

    # Print the results
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal Solution:")
        print(f"Airline Investment: ${x1.varValue:.2f}")
        print(f"Railway Investment: ${x2.varValue:.2f}")
        print(f"Max Profit: ${model.objVal:.2f}")
    else:
        print("The model is infeasible.")

solve_investment_problem()
