
from gurobipy import *

# Create a new model
m = Model("Framing_Company")

# Define variables
x1 = m.addVar(lb=0, vtype=GRB.INTEGER, name="printed_arts")
x2 = m.addVar(lb=0, vtype=GRB.INTEGER, name="paintings")

# Set the objective function
m.setObjective(5*x1 + 8*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(10*x1 <= 150, "printing_time")
m.addConstr(5*x1 + 15*x2 <= 400, "framing_time")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Number of printed arts: {x1.x}")
    print(f"Number of paintings: {x2.x}")
    print(f"Maximum profit: ${5*x1.x + 8*x2.x}")
else:
    print("No optimal solution found")
