
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(lb=0, name="printed_art")
    x2 = model.addVar(lb=0, name="paintings")

    # Objective function: maximize 5*x1 + 8*x2
    model.setObjective(5*x1 + 8*x2, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(10*x1 <= 150, name="printing_time")
    model.addConstr(5*x1 + 15*x2 <= 400, name="framing_time")

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Number of printed art: {x1.varValue}")
        print(f"Number of paintings: {x2.varValue}")
        print(f"Max profit: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
