
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("berry_transport")

# Create variables
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="berries_by_boat") # units carried by boat
x2 = m.addVar(vtype=GRB.CONTINUOUS, name="berries_by_neighbor") # units carried by neighbor
n1 = m.addVar(vtype=GRB.INTEGER, name="boat_trips") # number of boat trips
n2 = m.addVar(vtype=GRB.INTEGER, name="neighbor_trips") # number of neighbor trips


# Set objective function
m.setObjective(x1 + x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(30 * n1 + 8 * n2 <= 500, "budget_constraint")
m.addConstr(x1 == 200 * n1, "boat_capacity")
m.addConstr(x2 == 40 * n2, "neighbor_capacity")
m.addConstr(n1 <= n2, "trip_limit")
m.addConstr(n1 >= 0, "boat_trips_nonnegative")
m.addConstr(n2 >= 0, "neighbor_trips_nonnegative")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal number of berries transported: {m.objVal}")
    print(f"Number of boat trips: {n1.x}")
    print(f"Number of neighbor trips: {n2.x}")
    print(f"Berries carried by boat: {x1.x}")
    print(f"Berries carried by neighbor: {x2.x}")

elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

