
from gurobipy import *

# Create a new model
m = Model("berry_transportation")

# Define variables
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="boat_trips")
x2 = m.addVar(vtype=GRB.CONTINUOUS, name="neighbor_trips")

# Set the objective function
m.setObjective(200*x1 + 40*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(30*x1 + 8*x2 <= 500, "cost_constraint")
m.addConstr(x1 <= x2, "trip_constraint")
m.addConstr(x1 >= 0, "non_negativity_boat")
m.addConstr(x2 >= 0, "non_negativity_neighbor")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Number of boat trips: {x1.x}")
    print(f"Number of neighbor trips: {x2.x}")
    print(f"Total berries transported: {200*x1.x + 40*x2.x}")
else:
    print("No optimal solution found")
