
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(name="boat_trips", lb=0, ub=None, vtype=gurobi.GRB.INTEGER)
    x2 = model.addVar(name="neighbor_trips", lb=0, ub=None, vtype=gurobi.GRB.INTEGER)

    # Objective function: maximize 200*x1 + 40*x2
    model.setObjective(200*x1 + 40*x2, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(30*x1 + 8*x2 <= 500, name="cost_constraint")
    model.addConstr(x1 <= x2, name="boat_neighbor_constraint")

    # Solve the model
    model.optimize()

    # Check if the model is optimized
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal Solution:")
        print(f"Boat Trips: {x1.varValue}")
        print(f"Neighbor Trips: {x2.varValue}")
        print(f"Total Berries: {200*x1.varValue + 40*x2.varValue}")
    else:
        print("The model is infeasible.")

solve_optimization_problem()
