
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("chemical_plant")

# Create variables
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="Alnolyte") # packages of Alnolyte
x2 = m.addVar(vtype=GRB.CONTINUOUS, name="Blenzoate") # packages of Blenzoate

# Set objective function
m.setObjective(7*x1 + 10*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(5*x1 + 7*x2 <= 500, "Automatic Device Constraint")
m.addConstr(4*x1 + 3*x2 <= 500, "Human-Operated Device Constraint")
m.addConstr(x1 >= 0, "Non-negativity constraint for x1")
m.addConstr(x2 >= 0, "Non-negativity constraint for x2")


# Optimize model
m.optimize()

# Check for infeasibility
if m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    # Print optimal solution
    print(f"Optimal Revenue: ${m.objVal}")
    print(f"Number of Alnolyte packages: {x1.x}")
    print(f"Number of Blenzoate packages: {x2.x}")

