
from gurobipy import *

# Create a model
m = Model("Chemical_Plant_Optimization")

# Add variables
x1 = m.addVar(name="Alnolyte", vtype=GRB.CONTINUOUS, lb=0)
x2 = m.addVar(name="Blenzoate", vtype=GRB.CONTINUOUS, lb=0)

# Set the objective function
m.setObjective(7*x1 + 10*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(5*x1 + 7*x2 <= 500, name="Automatic_Device_Constraint")
m.addConstr(4*x1 + 3*x2 <= 500, name="Human_Operated_Device_Constraint")

# Optimize the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Alnolyte: {x1.x}")
    print(f"Blenzoate: {x2.x}")
    print(f"Maximum Revenue: {m.objVal}")
else:
    print("No optimal solution found")
