
import gurobipy as gp

# Create a new model
model = gp.Model("Chemical Plant Production")

# Define the variables
x1 = model.addVar(name="Alnolyte", lb=0, vtype=gp.GRB.CONTINUOUS)
x2 = model.addVar(name="Blenzoate", lb=0, vtype=gp.GRB.CONTINUOUS)

# Define the objective function
model.setObjective(7*x1 + 10*x2, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(5*x1 + 7*x2 <= 500, name="Automatic_Device_Constraint")
model.addConstr(4*x1 + 3*x2 <= 500, name="Human_Operated_Device_Constraint")

# Solve the model
model.optimize()

# Print the results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal solution: x1 = {x1.varValue}, x2 = {x2.varValue}")
    print(f"Maximum revenue: ${7*x1.varValue + 10*x2.varValue:.2f}")
else:
    print("No optimal solution found.")
