
import gurobipy as gp

# Create a new model
model = gp.Model("West_Moon_Designs")

# Create variables
coffee_tables = model.addVar(vtype=gp.GRB.CONTINUOUS, name="coffee_tables")  # x1
bookcases = model.addVar(vtype=gp.GRB.CONTINUOUS, name="bookcases")  # x2


# Set objective function
model.setObjective(200 * coffee_tables + 300 * bookcases, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(5 * coffee_tables + 7 * bookcases <= 120, "Lacquer_Constraint")
model.addConstr(15 * coffee_tables + 25 * bookcases <= 250, "Mahogany_Constraint")
model.addConstr(coffee_tables >= 0)
model.addConstr(bookcases >= 0)


# Optimize model
model.optimize()

# Print results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution Found. Maximum Profit: ${model.objVal}")
    print(f"Number of Coffee Tables to Produce: {coffee_tables.x}")
    print(f"Number of Bookcases to Produce: {bookcases.x}")
elif model.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {model.status}")

