
from gurobipy import *

# Create a new model
m = Model("West_Moon_Designs")

# Add variables
x1 = m.addVar(name='coffee_tables', vtype=GRB.CONTINUOUS, lb=0)
x2 = m.addVar(name='bookcases', vtype=GRB.CONTINUOUS, lb=0)

# Set the objective function
m.setObjective(200*x1 + 300*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(5*x1 + 7*x2 <= 120, name='lacquer_constraint')
m.addConstr(15*x1 + 25*x2 <= 250, name='mahogany_constraint')

# Optimize the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution: {x1.varName} = {x1.x}, {x2.varName} = {x2.x}")
    print(f"Maximum profit: {m.objVal}")
else:
    print("No optimal solution found")
