
import gurobipy as gp

# Create a new model
model = gp.Model("WestMoonDesigns")

# Define the variables
x1 = model.addVar(name="coffee_tables", lb=0, vtype=gp.GRB.CONTINUOUS)
x2 = model.addVar(name="bookcases", lb=0, vtype=gp.GRB.CONTINUOUS)

# Define the objective function
model.setObjective(200*x1 + 300*x2, gp.GRB.MAXIMIZE)

# Define the constraints
model.addConstr(5*x1 + 7*x2 <= 120, name="lacquer_constraint")
model.addConstr(15*x1 + 25*x2 <= 250, name="mahogany_constraint")

# Solve the model
model.optimize()

# Print the solution
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal production plan: {x1.varName} = {x1.x}, {x2.varName} = {x2.x}")
    print(f"Maximum profit: ${model.objVal:.2f}")
else:
    print("The model is infeasible or unbounded.")
