
from gurobipy import Model, GRB

# Create a new model
model = Model("GameShopOptimization")

# Create variables
kommand = model.addVar(vtype=GRB.INTEGER, name="kommand")  # Units of Kommand
kontrol = model.addVar(vtype=GRB.INTEGER, name="kontrol")  # Units of Kontrol


# Set objective function: Minimize total cost
model.setObjective(11 * kommand + 3 * kontrol, GRB.MINIMIZE)

# Add constraints
model.addConstr(14 * kommand + 8 * kontrol <= 500, "Budget")  # Budget constraint
model.addConstr(20 * kommand + 5 * kontrol >= 200, "CustomerTarget")  # Customer target constraint
model.addConstr(kommand >= 0, "NonNegativeKommand")  # Non-negativity constraint
model.addConstr(kontrol >= 0, "NonNegativeKontrol")  # Non-negativity constraint


# Optimize the model
model.optimize()

# Check if a solution was found
if model.status == GRB.OPTIMAL:
    print(f"Optimal solution found:")
    print(f"  Kommand: {kommand.x}")
    print(f"  Kontrol: {kontrol.x}")
    print(f"  Total Cost: {model.objVal}")
elif model.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {model.status}")

