
from gurobipy import *

# Create a new model
m = Model("GameShop_Optimization")

# Define variables
x1 = m.addVar(name='Kommand', vtype=GRB.CONTINUOUS, lb=0)
x2 = m.addVar(name='Kontrol', vtype=GRB.CONTINUOUS, lb=0)

# Set the objective function
m.setObjective(11*x1 + 3*x2, GRB.MINIMIZE)

# Add constraints
m.addConstr(14*x1 + 8*x2 <= 500, name='Budget_Constraint')
m.addConstr(20*x1 + 5*x2 >= 200, name='Customer_Attraction_Constraint')

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution found. Buy {x1.x} units of Kommand and {x2.x} units of Kontrol.")
else:
    print("No optimal solution found.")
