
import gurobipy as gp

# Create a new model
model = gp.Model("GameShop_Optimization")

# Define variables
x1 = model.addVar(name="Kommand_units", lb=0, vtype=gp.GRB.INTEGER)  # Number of units of Kommand
x2 = model.addVar(name="Kontrol_units", lb=0, vtype=gp.GRB.INTEGER)  # Number of units of Kontrol

# Objective function: Minimize the total cost
model.setObjective(11*x1 + 3*x2, gp.GRB.MINIMIZE)

# Budget constraint
model.addConstr(14*x1 + 8*x2 <= 500, name="Budget_Constraint")

# Customer attraction constraint
model.addConstr(20*x1 + 5*x2 >= 200, name="Customer_Attraction_Constraint")

# Solve the model
model.optimize()

# Print the results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal solution found: Kommand units = {x1.varValue}, Kontrol units = {x2.varValue}")
    print(f"Minimum cost: ${11*x1.varValue + 3*x2.varValue}")
else:
    print("No optimal solution found")
