
import gurobipy as gp

# Create a new model
model = gp.Model("Lotion_Optimization")

# Create variables
x1 = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="Eucalyptus_Lotion")  # Bottles of Eucalyptus lotion
x2 = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="Citrus_Lotion")  # Bottles of Citrus lotion


# Set objective function: Maximize profit
model.setObjective(1*x1 + 4*x2, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(6*x1 + 8*x2 <= 10000, "Inventory_Cost")  # Inventory cost constraint
model.addConstr(x1 + x2 <= 1500, "Demand")  # Demand constraint


# Optimize the model
model.optimize()

# Check for infeasibility
if model.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    # Print the optimal solution
    print("Optimal Solution:")
    print(f"Eucalyptus Lotion: {x1.x}")
    print(f"Citrus Lotion: {x2.x}")
    print(f"Maximum Profit: ${model.objVal}")

