
from gurobipy import *

# Create a new model
m = Model("Hand_Lotion_Optimization")

# Define variables
x1 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="Eucalyptus_lotion")
x2 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="Citrus_lotion")

# Set the objective function
m.setObjective(1*x1 + 4*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(6*x1 + 8*x2 <= 10000, "Cost_constraint")
m.addConstr(x1 + x2 <= 1500, "Sales_volume_constraint")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Eucalyptus lotion: {x1.x}")
    print(f"Citrus lotion: {x2.x}")
    print(f"Total profit: {m.objVal}")
else:
    print("No optimal solution found")
