
import gurobipy as gp

# Create a new model
model = gp.Model("Lotion_Optimization")

# Define the variables
x1 = model.addVar(name="Eucalyptus", lb=0, vtype=gp.GRB.INTEGER)  # Bottles of Eucalyptus lotion
x2 = model.addVar(name="Citrus", lb=0, vtype=gp.GRB.INTEGER)     # Bottles of Citrus lotion

# Objective function: Maximize profit
model.setObjective(1*x1 + 4*x2, gp.GRB.MAXIMIZE)

# Constraints
model.addConstr(x1 + x2 <= 1500, name="Total_Bottles")          # No more than 1500 bottles
model.addConstr(6*x1 + 8*x2 <= 10000, name="Inventory_Cost")   # Inventory cost not exceeding $10000

# Solve the model
model.optimize()

# Print the results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal solution found. Stock {x1.varValue} bottles of Eucalyptus lotion and {x2.varValue} bottles of Citrus lotion.")
    print(f"Maximum profit: ${1*x1.varValue + 4*x2.varValue}")
else:
    print("No optimal solution found.")
