
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("wood_shop")

# Create variables
bookcases = m.addVar(vtype=GRB.CONTINUOUS, name="bookcases")
coffee_tables = m.addVar(vtype=GRB.CONTINUOUS, name="coffee_tables")


# Set objective
m.setObjective(90 * bookcases + 65 * coffee_tables, GRB.MAXIMIZE)

# Add constraints
m.addConstr(bookcases <= 40, "bookcases_limit")
m.addConstr(coffee_tables <= 60, "coffee_tables_limit")
m.addConstr(7 * bookcases + 5 * coffee_tables <= 150, "labor_limit")
m.addConstr(bookcases >=0, "bookcases_nonneg")
m.addConstr(coffee_tables >=0, "coffee_tables_nonneg")



# Optimize model
m.optimize()

if m.status == GRB.OPTIMAL:
    print(f"Optimal profit: ${m.objVal}")
    print(f"Number of bookcases: {bookcases.x}")
    print(f"Number of coffee tables: {coffee_tables.x}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

