
from gurobipy import *

# Create a model
m = Model("Wood_Shop_Profit_Optimization")

# Define variables
x1 = m.addVar(lb=0, name="bookcases")
x2 = m.addVar(lb=0, name="coffee_tables")

# Set the objective function
m.setObjective(90*x1 + 65*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x1 <= 40, "max_bookcases")
m.addConstr(x2 <= 60, "max_coffee_tables")
m.addConstr(7*x1 + 5*x2 <= 150, "total_hours")

# Optimize the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Bookcases: {x1.x}")
    print(f"Coffee tables: {x2.x}")
    print(f"Total profit: {m.objVal}")
else:
    print("No optimal solution found")
