
import gurobipy as gp

# Create a new model
model = gp.Model("WoodShop")

# Define variables
x1 = model.addVar(lb=0, ub=40, name="bookcases")
x2 = model.addVar(lb=0, ub=60, name="coffee_tables")

# Objective function: maximize profit
model.setObjective(90*x1 + 65*x2, gp.GRB.MAXIMIZE)

# Constraints
model.addConstr(x1 <= 40, name="bookcase_limit")
model.addConstr(x2 <= 60, name="coffee_table_limit")
model.addConstr(7*x1 + 5*x2 <= 150, name="hour_limit")

# Solve the model
model.optimize()

# Print the solution
if model.status == gp.GRB.OPTIMAL:
    print("Optimal Solution:")
    print(f"Bookcases: {x1.varValue}")
    print(f"Coffee Tables: {x2.varValue}")
    print(f"Max Profit: {model.objVal}")
else:
    print("The model is infeasible.")
