
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("julia_supplement")

# Create variables
gamma = m.addVar(lb=0, name="gamma") # scoops of Gamma
delta = m.addVar(lb=0, name="delta") # scoops of Delta

# Set objective function
m.setObjective(1.5 * gamma + 2.5 * delta, GRB.MINIMIZE)

# Add constraints
m.addConstr(7 * gamma + 12 * delta >= 60, "iron_req")
m.addConstr(10 * gamma + 9 * delta >= 45, "biotin_req")


# Optimize model
m.optimize()

if m.status == GRB.OPTIMAL:
    print(f"Optimal cost: ${m.objVal:.2f}")
    print(f"Scoops of Gamma: {gamma.x:.2f}")
    print(f"Scoops of Delta: {delta.x:.2f}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

