
from gurobipy import *

# Create a new model
m = Model("Julia_Supplement_Problem")

# Define the variables
x1 = m.addVar(name="Gamma_Scoops", lb=0, vtype=GRB.CONTINUOUS)
x2 = m.addVar(name="Delta_Scoops", lb=0, vtype=GRB.CONTINUOUS)

# Set the objective function: Minimize cost
m.setObjective(1.5*x1 + 2.5*x2, GRB.MINIMIZE)

# Add constraints
m.addConstr(7*x1 + 12*x2 >= 60, name="Iron_Requirement")
m.addConstr(10*x1 + 9*x2 >= 45, name="Biotin_Requirement")

# Optimize the model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution found. Gamma scoops: {x1.x}, Delta scoops: {x2.x}")
    print(f"Total cost: ${1.5*x1.x + 2.5*x2.x:.2f}")
else:
    print("No optimal solution found.")
