
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="Gamma", lb=0)  # Number of scoops of Gamma
    x2 = model.addVar(name="Delta", lb=0)  # Number of scoops of Delta

    # Define the objective function
    model.setObjective(1.5 * x1 + 2.5 * x2, gurobi.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(7 * x1 + 12 * x2 >= 60, name="Iron_Requirement")
    model.addConstr(10 * x1 + 9 * x2 >= 45, name="Biotin_Requirement")

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Number of scoops of Gamma: {x1.varValue}")
        print(f"Number of scoops of Delta: {x2.varValue}")
        print(f"Total cost: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
