
import gurobipy as gp

# Create a new model
m = gp.Model("Sneaker_Profit")

# Create variables
x1 = m.addVar(vtype=gp.GRB.INTEGER, name="x1") # Brand A sneakers
x2 = m.addVar(vtype=gp.GRB.INTEGER, name="x2") # Brand B sneakers


# Set objective function
m.setObjective(50*x1 + 75*x2, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(100*x1 + 150*x2 <= 2000, "Budget")
m.addConstr(x1 + x2 <= 15, "Total Sneakers")
m.addConstr(x1 >= 0, "Non-negative x1")
m.addConstr(x2 >= 0, "Non-negative x2")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of Brand A sneakers (x1): {x1.x}")
    print(f"Number of Brand B sneakers (x2): {x2.x}")
    print(f"Maximum Profit: ${m.objVal}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

