
from gurobipy import *

# Create a new model
m = Model("Sneaker_Profit")

# Define variables
x1 = m.addVar(vtype=GRB.INTEGER, name="Brand_A_Sneakers")
x2 = m.addVar(vtype=GRB.INTEGER, name="Brand_B_Sneakers")

# Set the objective function
m.setObjective(50*x1 + 75*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(100*x1 + 150*x2 <= 2000, "Total_Cost")
m.addConstr(x1 + x2 <= 15, "Total_Sneakers")

# Optimize the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Number of Brand A sneakers: {x1.x}")
    print(f"Number of Brand B sneakers: {x2.x}")
    print(f"Maximum profit: {m.objVal}")
else:
    print("No optimal solution found")
