
import gurobi

def solve_sneaker_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="Brand_A", vtype=gurobi.GRB.INTEGER, lb=0)
    x2 = model.addVar(name="Brand_B", vtype=gurobi.GRB.INTEGER, lb=0)

    # Objective function: maximize 50*x1 + 75*x2
    model.setObjective(50*x1 + 75*x2, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(100*x1 + 150*x2 <= 2000, name="budget_constraint")
    model.addConstr(x1 + x2 <= 15, name="total_sneakers_constraint")

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal solution: x1 = {x1.varValue}, x2 = {x2.varValue}")
        print(f"Maximum profit: {model.objVal}")
    else:
        print("No optimal solution found")

solve_sneaker_problem()
