
import gurobipy as gp

# Create a new model
m = gp.Model("Emma's Diet")

# Create variables
pork = m.addVar(lb=0, name="pork")  # units of pork
shrimp = m.addVar(lb=0, name="shrimp")  # units of shrimp


# Set objective function: Minimize cost
m.setObjective(3 * pork + 5.5 * shrimp, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(15 * pork + 22 * shrimp >= 120, "Protein Requirement")
m.addConstr(4 * pork + 7 * shrimp >= 30, "Fat Requirement")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal Cost: ${m.objVal:.2f}")
    print(f"Units of Pork: {pork.x:.2f}")
    print(f"Units of Shrimp: {shrimp.x:.2f}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

