
from gurobipy import *

# Create a new model
m = Model("Emma_Diet")

# Add variables to the model
x1 = m.addVar(lb=0, name="pork")
x2 = m.addVar(lb=0, name="shrimp")

# Set the objective function
m.setObjective(3*x1 + 5.5*x2, GRB.MINIMIZE)

# Add constraints to the model
m.addConstr(15*x1 + 22*x2 >= 120, "Protein_Constraint")
m.addConstr(4*x1 + 7*x2 >= 30, "Fat_Constraint")

# Optimize the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Units of pork: {x1.x}")
    print(f"Units of shrimp: {x2.x}")
    print(f"Total cost: {m.objVal}")
else:
    print("No optimal solution found.")
