
import gurobi

def solve_diet_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="pork", lb=0)
    x2 = model.addVar(name="shrimp", lb=0)

    # Objective function: minimize 3*x1 + 5.5*x2
    model.setObjective(3*x1 + 5.5*x2, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(15*x1 + 22*x2 >= 120, name="protein_requirement")
    model.addConstr(4*x1 + 7*x2 >= 30, name="fat_requirement")

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Pork: {x1.varValue}")
        print(f"Shrimp: {x2.varValue}")
        print(f"Minimum cost: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_diet_problem()
