
import gurobipy as gp

# Create a new model
m = gp.Model("concrete_mix")

# Create variables
x1 = m.addVar(lb=0, name="mix_A") # units of mix A
x2 = m.addVar(lb=0, name="mix_B") # units of mix B

# Set objective function
m.setObjective(1*x1 + 1.25*x2, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(5*x1 + 6*x2 >= 70, "cement")
m.addConstr(2*x1 + 1*x2 >= 20, "sand")
m.addConstr(1*x1 + 2*x2 >= 15, "gravel")


# Optimize model
m.optimize()

# Check for infeasibility
if m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    # Print optimal solution
    print(f"Optimal cost: ${m.objVal:.2f}")
    print(f"Units of mix A: {x1.x:.2f}")
    print(f"Units of mix B: {x2.x:.2f}")

