
from gurobipy import *

# Create a new model
model = Model("Concrete_Mix")

# Define variables
x1 = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="mix_A")
x2 = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="mix_B")

# Set the objective function
model.setObjective(1*x1 + 1.25*x2, GRB.MINIMIZE)

# Add constraints
model.addConstr(5*x1 + 6*x2 >= 70, "cement")
model.addConstr(2*x1 + x2 >= 20, "sand")
model.addConstr(x1 + 2*x2 >= 15, "gravel")

# Optimize the model
model.optimize()

# Print the results
if model.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Mix A: {x1.x} units")
    print(f"Mix B: {x2.x} units")
    print(f"Total Cost: ${model.objVal:.2f}")
else:
    print("No optimal solution found.")
