
import gurobi

def solve_concrete_mix_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="x1", lb=0, ub=float('inf'), obj=1)  # units of mix A
    x2 = model.addVar(name="x2", lb=0, ub=float('inf'), obj=1.25)  # units of mix B

    # Add constraints
    model.addConstr(5 * x1 + 6 * x2 >= 70, name="cement_constraint")  # cement constraint
    model.addConstr(2 * x1 + x2 >= 20, name="sand_constraint")  # sand constraint
    model.addConstr(x1 + 2 * x2 >= 15, name="gravel_constraint")  # gravel constraint

    # Set the model to minimize
    model.setObjective(x1 + 1.25 * x2, gurobi.GRB.MINIMIZE)

    # Optimize the model
    model.optimize()

    # Check if the model is optimized
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Units of mix A: {x1.varValue}")
        print(f"Units of mix B: {x2.varValue}")
        print(f"Total cost: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_concrete_mix_problem()
