
import gurobipy as gp

# Create a new model
m = gp.Model("monitor_production")

# Create variables
lcd = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="lcd")  # Number of LCD monitors
led = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="led")  # Number of LED monitors


# Set objective function
m.setObjective(25 * lcd + 70 * led, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(lcd >= 150, "lcd_demand")
m.addConstr(led >= 80, "led_demand")
m.addConstr(lcd <= 300, "lcd_production_limit")
m.addConstr(led <= 280, "led_production_limit")
m.addConstr(lcd + led >= 250, "total_production")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of LCD monitors to produce: {lcd.x}")
    print(f"Number of LED monitors to produce: {led.x}")
    print(f"Maximum profit: ${m.objVal}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

