
from gurobipy import *

# Create a new model
m = Model("Monitor_Production")

# Define variables
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="LCD_Monitors")
x2 = m.addVar(vtype=GRB.CONTINUOUS, name="LED_Monitors")

# Set the objective function: Maximize profit
m.setObjective(25*x1 + 70*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x1 >= 150, "LCD_Demand")
m.addConstr(x2 >= 80, "LED_Demand")
m.addConstr(x1 <= 300, "LCD_Production_Limit")
m.addConstr(x2 <= 280, "LED_Production_Limit")
m.addConstr(x1 + x2 >= 250, "Total_Monitors_Requirement")

# Optimize the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"LCD Monitors: {x1.x}")
    print(f"LED Monitors: {x2.x}")
    print(f"Total Profit: ${25*x1.x + 70*x2.x:.2f}")
else:
    print("No optimal solution found")
