
import gurobipy as gp

# Create a new model
model = gp.Model("Zeta_Monitor_Production")

# Define the variables
x1 = model.addVar(lb=0, name="LCD_monitors")  # Number of LCD monitors
x2 = model.addVar(lb=0, name="LED_monitors")  # Number of LED monitors

# Objective function: Maximize profit
model.setObjective(25*x1 + 70*x2, gp.GRB.MAXIMIZE)

# Constraints
model.addConstr(x1 >= 150, name="LCD_demand")
model.addConstr(x2 >= 80, name="LED_demand")
model.addConstr(x1 <= 300, name="LCD_production_limit")
model.addConstr(x2 <= 280, name="LED_production_limit")
model.addConstr(x1 + x2 >= 250, name="total_monitors_contract")

# Solve the model
model.optimize()

# Print the solution
if model.status == gp.GRB.OPTIMAL:
    print("Optimal Solution:")
    print(f"LCD monitors: {x1.varValue}")
    print(f"LED monitors: {x2.varValue}")
    print(f"Max Profit: {model.objVal}")
else:
    print("No optimal solution found.")
