
import gurobipy as gp

# Create a new model
model = gp.Model("Seafood Medley Optimization")

# Create decision variables
x1 = model.addVar(vtype=gp.GRB.CONTINUOUS, name="Seafood Medley One")  # Packages of seafood medley one
x2 = model.addVar(vtype=gp.GRB.CONTINUOUS, name="Seafood Medley Two")  # Packages of seafood medley two


# Set objective function: Maximize profit
model.setObjective(20 * x1 + 25 * x2, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(20 * x1 + 40 * x2 <= 10000, "Scallops Constraint")
model.addConstr(30 * x1 + 40 * x2 <= 12000, "Mussels Constraint")
model.addConstr(50 * x1 + 20 * x2 <= 11000, "Oysters Constraint")
model.addConstr(x1 >= 0, "Non-negativity x1")
model.addConstr(x2 >= 0, "Non-negativity x2")


# Optimize the model
model.optimize()

# Print the results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution Found. Maximum Profit: ${model.objVal}")
    print(f"Number of Seafood Medley One packages: {x1.x}")
    print(f"Number of Seafood Medley Two packages: {x2.x}")
elif model.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status: {model.status}")

