
from gurobipy import *

# Create a new model
m = Model("Seafood_Medley")

# Define variables
x1 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="x1")
x2 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="x2")

# Set the objective function
m.setObjective(20*x1 + 25*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(20*x1 + 40*x2 <= 10000, "scallops")
m.addConstr(30*x1 + 40*x2 <= 12000, "mussels")
m.addConstr(50*x1 + 20*x2 <= 11000, "oysters")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"x1 = {x1.x}")
    print(f"x2 = {x2.x}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found")
