
import gurobipy as gp

# Create a new model
model = gp.Model("Seafood_Medley_Optimization")

# Define variables
x1 = model.addVar(name="seafood_medley_one", lb=0, vtype=gp.GRB.CONTINUOUS)
x2 = model.addVar(name="seafood_medley_two", lb=0, vtype=gp.GRB.CONTINUOUS)

# Define objective function
model.setObjective(20*x1 + 25*x2, gp.GRB.MAXIMIZE)

# Define constraints
model.addConstr(20*x1 + 40*x2 <= 10000, name="scallops_constraint")
model.addConstr(30*x1 + 40*x2 <= 12000, name="mussels_constraint")
model.addConstr(50*x1 + 20*x2 <= 11000, name="oysters_constraint")

# Solve the model
model.optimize()

# Print the solution
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal solution: seafood medley one = {x1.varValue}, seafood medley two = {x2.varValue}")
    print(f"Maximum profit: ${model.objVal:.2f}")
else:
    print("No optimal solution found.")
