
import gurobipy as gp

# Create a new model
m = gp.Model("stationary_store")

# Create variables
pens = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="pens")
pencils = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="pencils")


# Set objective function
m.setObjective(3 * pens + pencils, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(2 * pens + pencils <= 500, "budget_constraint")
m.addConstr(pens >= 100, "min_pens")
m.addConstr(pens <= 150, "max_pens")
m.addConstr(pencils <= 2 * pens, "pencil_pen_ratio")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal profit: ${m.objVal:.2f}")
    print(f"Number of pens to buy and sell: {pens.x}")
    print(f"Number of pencils to buy and sell: {pencils.x}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

