
from gurobipy import *

# Create a new model
m = Model("Stationary Store Optimization")

# Define the variables
x1 = m.addVar(name='pens', lb=0)
x2 = m.addVar(name='pencils', lb=0)

# Set the objective function
m.setObjective(3*x1 + x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(2*x1 + x2 <= 500, name='inventory_limit')
m.addConstr(x1 >= 100, name='min_pens_sold')
m.addConstr(x1 <= 150, name='max_pens_sold')
m.addConstr(x2 <= 2*x1, name='pencils_vs_pens')

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution: {x1.varName} = {x1.x}, {x2.varName} = {x2.x}")
    print(f"Maximum profit: {m.objVal}")
else:
    print("No optimal solution found")
