
import gurobi

def solve_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(lb=100, ub=150, name="pens")  # At least 100, at most 150 pens
    x2 = model.addVar(lb=0, name="pencils")  # Non-negative number of pencils

    # Objective function: Maximize 3*x1 + x2
    model.setObjective(3*x1 + x2, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(2*x1 + x2 <= 500, name="inventory_cost")  # Inventory cost constraint
    model.addConstr(x2 <= 2*x1, name="pencils_vs_pens")  # Pencils vs pens constraint

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Number of pens: {x1.varValue}")
        print(f"Number of pencils: {x2.varValue}")
        print(f"Max Profit: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_problem()
