
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("nut_mix")

# Create variables
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="x1") # Mixture 1
x2 = m.addVar(vtype=GRB.CONTINUOUS, name="x2") # Mixture 2


# Set objective
m.setObjective(10*x1 + 12*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(20*x1 + 15*x2 <= 1000, "almonds")
m.addConstr(30*x1 + 20*x2 <= 1200, "pecans")
m.addConstr(10*x1 + 25*x2 <= 1100, "pistachios")
m.addConstr(x1 >= 0)
m.addConstr(x2 >= 0)


# Optimize model
m.optimize()

if m.status == GRB.OPTIMAL:
    print(f"Optimal profit: ${m.objVal:.2f}")
    print(f"Mixture 1: {x1.x:.2f}")
    print(f"Mixture 2: {x2.x:.2f}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

