
from gurobipy import *

# Create a model
m = Model("Nut_Mixture")

# Define variables
x1 = m.addVar(name="Mixture_1", vtype=GRB.CONTINUOUS, lb=0)
x2 = m.addVar(name="Mixture_2", vtype=GRB.CONTINUOUS, lb=0)

# Set objective function
m.setObjective(10*x1 + 12*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(20*x1 + 15*x2 <= 1000, name="Almond_Constraint")
m.addConstr(30*x1 + 20*x2 <= 1200, name="Pecan_Constraint")
m.addConstr(10*x1 + 25*x2 <= 1100, name="Pistachio_Constraint")

# Optimize the model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Mixture 1: {x1.x}")
    print(f"Mixture 2: {x2.x}")
    print(f"Maximum Profit: {m.objVal}")
else:
    print("No optimal solution found")
